<?php

  /**
   * @link       https://www.obituary-assistant.com
   * @since      1.0.0
   *
   * @package    Fhw_Solutions_Obituaries
   * @subpackage Fhw_Solutions_Obituaries/public/partials
   */

    $page = $jsonString["current_page"];

    //create paging
    if (!function_exists('fws_paging_all_obits'))   {
      function fws_paging_all_obits($actual_link,$totalpages,$page,$previous,$more ){ ?>
        <nav aria-label="bottomobitnav">
          <ul class="ps-3 ms-0 pagination">
            <li class="page-item ms-auto <?php if($page < 2){echo "disabled";}?>">
              <?php
                if ($page < 2) {
                    echo '<a class="page-link" tabindex="-1" aria-disabled="true" href="' . $actual_link . '/">&laquo; ' . $previous . '</a>';
                } else {
                    echo '<a class="page-link" aria-disabled="false" aria-label="Previous" href="' . $actual_link . '/' . ($page - 1) . '/">&laquo; ' .  $previous . '</a>';
                }
              ?>
            </li>
            <li class="page-item <?php if($totalpages <= $page){echo "disabled";}?>">
              <?php
                if ($totalpages < $page) {
                  echo '<a class="page-link" tabindex="-1" aria-disabled="true" href="' . $actual_link . '/' . ($page + 1) . '/">' . $more . ' &raquo;</a>';
                } else {
                  echo '<a class="page-link" aria-disabled="false" aria-label="next" href="' . $actual_link . '/' . ($page + 1) . '/">' . $more . ' &raquo;</a>';
                }
              ?>
            </li>
          </ul>
        </nav>
      <?php }
    }

    //create each obit card
    if (!function_exists('fhws_display_obits_card')) {
      function fhws_display_obits_card($link, $name, $obitDates, $image, $detail, $preview, $location, $extra_buttons, $trees_only_button, $flowers_only_button) {
        $truncate = (strlen($preview) === 200) ? "..." : "";
        $obitDatesMobile = explode(' - ', $obitDates);
        ?>
        <div class="row no-gutters">
          <div class="col-12">
            <div class="obit_listing d-sm-flex border-0 text-center text-sm-start pt-5">
              <!-- mobile name and date -->
              <div class="d-sm-none">
                <div class="obit_name lh-l">
                  <a class="text-decoration-none" href="<?php echo $link; ?>/"><?php echo $name; ?></a>
                </div>
                <?php if(isset($obitDatesMobile[0])){ ?>
                  <p class="mb-0"><?php echo $obitDatesMobile[0];?></p>
                <?php } ?>
                <?php if(isset($obitDatesMobile[1])){ ?>
                  <p class="mb-0"><?php echo " - " . $obitDatesMobile[1];?></p>
                <?php } ?>
              </div>
              <!--  image -->
              <div class="order-1 my-3 my-sm-0" style="flex: 0 0 200px;">
                <a  href="<?php echo $link;?>/">
                  <img src="<?php echo $image;?>"  style="width:150px;" alt="<?php echo $name; ?>"/>
                </a>
              </div>
              <!-- info -->
              <div class="order-2 flex-fill">
                <div class="d-none d-sm-block">
                  <div class="obit_name lh-l">
                    <a class="text-decoration-none" href="<?php echo $link; ?>/"><?php echo $name; ?></a>
                  </div>
                  <p class="mb-3"><?php echo $obitDates;?></p>
                </div>
                <div class="order-3">
                  <?php if($preview != ""){ ?> <p class="lh-base"><?php echo $preview . $truncate; ?></p><?php }?>
                  <?php if($location != ""){ ?> <p>@ <?php echo $location;?></p> <?php }?>
                </div>
              </div>
            </div>
            <ul class="lh-sm nav nav-pills mb-2 nav-sm-fill ms-0 flex-column flex-sm-row text-center justify-content-end"  role="tablist">
              <li class="nav-item py-1 mx-sm-1" role="presentation">
                <a class="border nav-link py-1 h-100 fw-normal" href="<?php echo $link;?>/"  aria-current="page"><?php echo $detail; ?></a>
              <?php if ($flowers_only_button != "") { ?>
                <li class="nav-item py-1 mx-sm-1" role="presentation">
                  <a class="border nav-link py-1 h-100 fw-normal" href="<?php echo $link;?>/?show_flowers=1" ><?php echo $flowers_only_button;?></a>
                </li>
              <?php } else if ($extra_buttons != "") { ?>
                <li class="nav-item py-1 mx-sm-1" role="presentation">
                  <a class="border nav-link py-1 h-100 fw-normal" href="<?php echo $link;?>/?show_flowers=1" ><?php echo $extra_buttons;?></a>
                </li>
                <li class="nav-item py-1 mx-sm-1" role="presentation">
                  <a class="border nav-link py-1 h-100 fw-normal" href="<?php echo $link;?>/?show_trees=1">Plant Trees</a>
                </li>
               <?php } else if ($trees_only_button != "") { ?>
                <li class="nav-item py-1 mx-sm-1" role="presentation">
                  <a class="border nav-link py-1 h-100 fw-normal" href="<?php echo $link;?>/?show_trees=1"><?php echo $trees_only_button;?></a>
                </li>
              <?php } ?>
            </ul>
            <div class="d-none d-sm-block" style="padding:5px 0 5px 225px">
              <hr>
            </div>
            <div class="d-block d-sm-none" style="padding:5px 10px 5px 10px">
              <hr>
            </div>
          </div>
        </div>
    <?php }
  }
  ?>

<style>
  .modal-backdrop {
    z-index:1 !important;
 }
</style>

<?php
  $searchIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
  <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
</svg></span>';

  $elements = get_option('fhw-solutions-elements');
  $fh_info = get_option('fhw-solutions-obituaries_1');

  $obituarySubmissionLink = '<a href="/' . get_option('fhw-solutions-obituaries_2')['obituary_page_name'] . '/obituary-submission">' . $elements["SUBMIT_AN_OBITUARY"] . '</a>';

?>

<div class="fhw-solutions-obituaries_all-obituary-listings bootstrap-fhws-obituaries-container p-2">
  <!-- subscribe and search -->
  <div class="row mb-4 justify-content-end">
    <div class="col-md-6 text-end">
      <a href="#" id="subscribe_to_client" data-modal-action="Subscribe to Obits" data-bs-toggle="modal" data-bs-target="#fhws-share-subscribe-modal"  class="subscribe_to_client text-decoration-none mb-2"><?php echo $jsonString["CLIENT_ELEMENTS"]["SUBSCRIBE_TO_CLIENT_LINK"];?></a>
      <div class="input-group mt-3">
        <input type="text" class="form-control fhw-solutions-obituaries_search-all-obits" name="fhw-solutions-obituaries_search-all-obits" id="fhw-solutions-obituaries_search-all-obits" placeholder="<?php echo $jsonString["CLIENT_ELEMENTS"]["SEARCH_PLACEHOLDER"]; ?>" aria-label="Recipient's username" aria-describedby="button-addon2">
        <button class="fhw-solutions-obituaries_search-all-obits-button" name="fhw-solutions-obituaries_search-all-obits-button" id="fhw-solutions-obituaries_search-all-obits-button" type="button"><?php echo $searchIcon . '<span class="d-none d-md-inline-block ps-1">' . $jsonString["CLIENT_ELEMENTS"]["SEARCH"] . '</span>';?></button>
      </div>
      <div class="pt-4">
        <?php echo (array_key_exists('OBITUARY_SUBMISSION', $elements) && $jsonString["CLIENT_CONFIG"]['SUBMISSION_BY_FAMILY_ALLOW'] == 1 ?  $obituarySubmissionLink : '') ?>
      </div>
    </div>
  </div>

  <?php

    $actual_link = '/' . get_option('fhw-solutions-obituaries_2')['obituary_page_name'];
    // generate each obits
    for ($i=0;$i<count($jsonString["OBITUARIES"]);$i++) {

      $obit_link = $actual_link . '/' . $jsonString["OBITUARIES"][$i]["OBIT_URL_REWRITE"];
      $name = $jsonString["OBITUARIES"][$i]["FIRST_NAME"].' '.$jsonString["OBITUARIES"][$i]["MIDDLE_NAME"].' '.$jsonString["OBITUARIES"][$i]["LAST_NAME"];
      $image = $jsonString["OBITUARIES"][$i]["IMAGE_S3"];
      $detail = $jsonString["CLIENT_ELEMENTS"]["VIEW_DETAILS"];
      $obitBornDate = $jsonString["OBITUARIES"][$i]["BORN_DATE"];
      $obitPassedDate = $jsonString["OBITUARIES"][$i]["DIED_DATE"];
      $preview = ($jsonString["CLIENT_CONFIG"]["MAIN_OBITS_TEXT_PREVIEW"] == 1) ? substr(strip_tags($jsonString["OBITUARIES"][$i]["OBIT_TEXT_OG_META"]), 0, 200) : "";
      $location = ($jsonString["CLIENT_CONFIG"]["CLIENT_SHOW_OBITUARY_LOCATION_TAG"] == 1) ? $jsonString["OBITUARIES"][$i]["FUNERAL_HOME_NAME"] : "";
      $extra_buttons = ($jsonString["CLIENT_CONFIG"]["FHWS_A_T"] == 0 && $jsonString["OBITUARIES"][$i]["DISABLE_FLOWERS"] == 0 || $jsonString["CLIENT_CONFIG"]["FHWS_A_T"] == 2 && $jsonString["OBITUARIES"][$i]["DISABLE_FLOWERS"] == 0) ? $jsonString["CLIENT_NAVIGATION"]["FLOWERS"] : "" ;
      $trees_only_button = ($jsonString["CLIENT_CONFIG"]["FHWS_A_T"] == 5 || $jsonString["CLIENT_CONFIG"]["FHWS_A_T"] == 7) ? "Plant Trees" : "" ;
      $flowers_only_button = ($jsonString["CLIENT_CONFIG"]["FHWS_A_T"] == 6) ? "Send Flowers" : "" ;

      if ($obitBornDate && $obitPassedDate) {
          $obitDates = $obitBornDate.' - '.$obitPassedDate;
      } elseif ($obitBornDate && !$obitPassedDate) {
          $obitDates = sprintf(__($jsonString["CLIENT_ELEMENTS"]["BORN"] . ' %s'), $obitBornDate);
      } elseif (!$obitBornDate && $obitPassedDate) {
          $obitDates = sprintf(__($jsonString["CLIENT_ELEMENTS"]["DIED"] . ' %s'), $obitPassedDate);
      } else {
          $obitDates = '';
      }

      fhws_display_obits_card($obit_link, $name, $obitDates, $image, $detail, $preview, $location, $extra_buttons, $trees_only_button, $flowers_only_button);
    }

    if ((!(count($jsonString["OBITUARIES"]))) && isset($searchString)){
      echo '<div class="row">';
      echo '<div class="obit_listing" style="border-bottom: 0; min-height: 100px;">';
      echo '<p>No results were found. Please try the last name or first name only.</p>';
      echo '</div>';
      echo '</div>';
    }
    else if (!(count($jsonString["OBITUARIES"]))){
      echo '<div class="row">';
      echo '<div class="obit_listing" style="border-bottom: 0; min-height: 100px;">';
      echo '<p>No obituaries have been added yet.</p>';
      echo '</div>';
      echo '</div>';
    }

    echo '<div class="row">';

    //link
    if (count($jsonString["OBITUARIES"])) {
        echo '<div class="obit_listing" style="border-bottom: 0; min-height: 20px;"><a class="fhw-solutions-obituaries_company-link" href="https://www.obituary-assistant.com/" target="_blank" >by Obituary Assistant</a></div>';
    }
    echo '</div>';
    echo '<div class="row">';
    //paging

    fws_paging_all_obits($actual_link,$jsonString['TOTAL_PAGES'],$page, $jsonString["CLIENT_ELEMENTS"]["PREVIOUS_OBITUARIES"], $jsonString["CLIENT_ELEMENTS"]["MORE_OBITUARIES"]);
    echo '</div>';

    if ($jsonString['CLIENT_INFO']['OBITUARY_ARCHIVE'] != ""){
      echo '<div id="id="fhws-obituary-archive" class="row text-center text-decoration-none"><a class="fs-5 text-decoration-none" href="' . $jsonString['CLIENT_INFO']['OBITUARY_ARCHIVE'] . '">Obituary Archive</a></div>';
    }
    ?>

  <?php
    echo '<input type="hidden" name="subscribe_to_client_popup_explanation" id="subscribe_to_client_popup_explanation" value="' . $jsonString["CLIENT_ELEMENTS"]["SUBSCRIBE_TO_CLIENT_POPUP_EXPLANATION"] . '">';
    echo '<input type="hidden" name="placeholder" id="placeholder" value="' . $jsonString["CLIENT_ELEMENTS"]["SUBSCRIBE_TO_CLIENT_POPUP_EXPLANATION"] . '">';
    echo '<input type="hidden" name="enter_your_phone_number" id="enter_your_phone_number" value="' . $jsonString["CLIENT_ELEMENTS"]["ENTER_YOUR_PHONE_NUMBER"] . '">';
    echo '<input type="hidden" name="enter_your_email_address" id="enter_your_email_address" value="' . $jsonString["CLIENT_ELEMENTS"]["ENTER_YOUR_EMAIL_ADDRESS"] . '">';
    echo '<input type="hidden" name="fhws_input_placeholder" id="fhws_input_placeholder" value="' . $jsonString["CLIENT_ELEMENTS"]["POPUP_PLACEHOLDER"] . '">';
    echo '<input type="hidden" id="popup_submit" value="' . $jsonString["CLIENT_ELEMENTS"]["PHOTO_BUTTON_1"] . '">';
    echo '<input type="hidden" id="popup_cancel" value="' . $jsonString["CLIENT_ELEMENTS"]["PHOTO_BUTTON_2"] . '">';
  ?>

 </div>
